/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.util;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RayTraceHelper {
    public static Optional<HitResult> rayTrace(Level worldIn, Entity entityIn, Vec3 start, Vec3 dir, double blockReach, double entityReach, Predicate<Entity> selector) {
        Vec3 end = start.m_82549_(dir.m_82490_(blockReach));
        BlockHitResult raytraceresult = worldIn.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entityIn));
        if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
            end = raytraceresult.m_82450_();
            entityReach = start.m_82554_(end);
        } else {
            end = start.m_82549_(dir.m_82490_(entityReach));
        }
        AABB area = entityIn.m_20191_().m_82369_(dir.m_82490_(entityReach)).m_82400_(1.0);
        EntityHitResult entityraytraceresult = RayTraceHelper.rayTrace(worldIn, entityIn, start, end, area, selector);
        if (entityraytraceresult != null) {
            raytraceresult = entityraytraceresult;
        }
        return Optional.ofNullable(raytraceresult);
    }

    @Nullable
    public static EntityHitResult rayTrace(Level worldIn, Entity entityIn, Vec3 start, Vec3 end, AABB boundingBox, Predicate<Entity> selector) {
        return RayTraceHelper.rayTrace(worldIn, entityIn, start, end, boundingBox, selector, Double.MAX_VALUE);
    }

    @Nullable
    public static EntityHitResult rayTrace(Level worldIn, Entity entityIn, Vec3 start, Vec3 end, AABB boundingBox, Predicate<Entity> selector, double limitDist) {
        double currentDist = limitDist;
        Entity resultEntity = null;
        for (Entity foundEntity : worldIn.m_6249_(entityIn, boundingBox, selector)) {
            double newDist;
            AABB axisalignedbb = foundEntity.m_20191_().m_82400_(0.5);
            Optional optional = axisalignedbb.m_82371_(start, end);
            if (!optional.isPresent() || !((newDist = start.m_82557_((Vec3)optional.get())) < currentDist)) continue;
            resultEntity = foundEntity;
            currentDist = newDist;
        }
        if (resultEntity == null) {
            return null;
        }
        return new EntityHitResult(resultEntity);
    }
}

